/* 
   CC0 2011, Martin Haye

   To the extent possible under law, Martin Haye has waived all copyright 
   and related or neighboring rights to p2e: Pseudo-II Emulator. 
   This work is published from: United States.
*/

/* Support for Apple II text mode */

var charData;
var charImages = {};
var enhanced = true;
var flashFlg = 0;
var textLineAddrs = new Array();

/** Initialize text mode */
function textInit() 
{
  // Calculate the address of each line using Woz's crazy / ingenious scheme
  var addr = 0x400;
  for (i=0; i<24; i++) {
    textLineAddrs[i] = addr;
    addr += 0x80;
    if (addr >= 0x800)
      addr = addr - 0x400 + 0x28;
  }
}

/** Establish the raw data for the character set */
function setCharset(_charData)
{
  charData = _charData;
}

/** Get, or generate, the image for a given byte code */
function getCharImage(val, inverse)
{
  // Do we have a cached image?
  var img = charImages[(val<<1) + inverse];
  if (img == undefined)
  {
    // Nope, gotta make a new one.
    img = mainCtx.createImageData(7, 8);
    var col = val % 16;
    var row = (val-col) / 16;
    var sp = (row*16*8*8) + (col*8);
    var dp = 0;
    for (var y=0; y<8; y++) {
      for (var x=0; x<7; x++) {
        var onOff = charData.charCodeAt(sp+x) & 0xFF;
        if (inverse)
          onOff = 255 - onOff;
        img.data[dp++] = onOff;
        img.data[dp++] = onOff;
        img.data[dp++] = onOff;
        img.data[dp++] = 255;
      }
      sp += 128;
    }
    charImages[(val<<1) + inverse] = img;
  }
  
  // All done.
  return img;
}

// Called when text memory is modified
function text_set(addr, val)
{
  var prev = raw_mem[addr];
  if (prev != val) 
  {
    raw_mem[addr] = val;
    
    // Compute the coordinates of the targeted character
    var y = (addr & 0x3FF) >> 7;
    addr &= 0x7F;
    var x = addr % 40;
    y += (addr-x) / 5;
    
    // If not in a screen hole, draw it.
    if (y < 24)
      drawChar(x, y, val);
  }
}

// Put a character on-screen
function drawChar(x, y, val)
{
  var code = ((val & 0x3F) ^ 0x20) + 0x20;
  if (enhanced && val >= 0xE0)
    code += 0x40;
  var inv = (val < 0x40) ? 1 : (val < 0x80) ? flashFlg : 0;
  mainCtx.putImageData(getCharImage(code, inv), x*7, y*8);
}

// Redraw the text screen
function redrawText()
{
  for (var y = 0; y < 40; y++) {
    var addr = textLineAddrs[y];
    for (var x = 0; x < 40; x++)
      drawChar(x, y, raw_mem[addr+x]);
  }
}
